/*****************************************************************************
*  LPC8xx SCT demo program
*
*  Use SCT timer to generate a two-channel double-edge controlled PWM
*  intended for use as a complementary PWM pair with dead-time control
*****************************************************************************/
#include "LPC8xx.h"

extern void SCT_Init(void);

void SCT_IRQHandler(void)
{
    LPC_SCT->CTRL_L |=  (1 << 3);                      // clear the L counter
    LPC_SCT->CTRL_L &= ~(1 << 1);                      // start the L counter

    LPC_SCT->EVFLAG  = (1 << 1);                       // clear event 1 interrupt flag
}

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL |= (1 << 7)              // enable clock to SWM
                               | (1 << 8);             // enable the SCT clock

    LPC_SWM->PINASSIGN5 = 0x06FFFFFF;                  // SCT_IN0  at P0_6 used as ABORT
    LPC_SWM->PINASSIGN6 = 0x07FFFFFF;                  // SCT_OUT0 at P0_7
    LPC_SWM->PINASSIGN7 = 0xFFFFFF08;                  // SCT_OUT1 at P0_8

    SCT_Init();                                       // Initialize SCT0

    while (1)                                          // loop forever
    {
    }
}
